(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     25203,        913]*)
(*NotebookOutlinePosition[     26294,        950]*)
(*  CellTagsIndexPosition[     26206,        944]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["Undetermined Coefficients"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell["Corrected 2/24/98", "SmallText"],

Cell[TextData[{
  "This notebook finds a particular solution of a linear differential \
equation by the method of undetermined coefficients. It is partially \
automated, but ",
  StyleBox[
  "you have to manually supply the information from which an annihilator of \
the right hand side can be constructed",
    FontWeight->"Bold"],
  ". \nThe notebook then checks your work. \n\nWhen your annihilator is \
correct, the notebook proceeds to follow the steps you would follow if you \
were solving the problem manually. This gives you a check on your work if you \
are working the problem manually in parallel. \n\nAfter constructing a system \
of equations which the coefficients in the assumed solution must satisfy, \
these equations are solved, and a particular solution generated. The notebook \
then checks this particular solution and then constructs a complete solution \
for the given problem. \n\n",
  StyleBox[
  "Change the statement of the problem if you want to solve a different \
problem",
    FontWeight->"Bold"],
  ". \nThe cells in boxes are where you define the problem to be solved.  \
Modify these boxed cells."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["A Look at DKernel"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "The function ",
  StyleBox["DKernel",
    FontWeight->"Bold"],
  " is central to what follows. Here is what DKernel says about itself."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Information["\<DKernel\>", LongForm \[Rule] False]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \("DKernel[eqn,y[x],x] finds a kernel for a single constant coefficients \
homogeneous linear differential equation eqn. The parameters have the same \
form as those of DSolve."\)], "Print",
  CellTags->"Info3306946056-4776161"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Statement of the problem"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Solve the sample nonhomogeneous problem ",
  StyleBox["y''[x]-3 y'[x] == 8 E^(3x)+4 Sin[x]",
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[{\(Clear[L, rhs, x, y];\), "\n", 
    RowBox[{
      RowBox[{\(L[x_, y_]\), "=", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}], "-", 
          RowBox[{"3", " ", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}]}]}], 
      ";"}], "\n", \(rhs[x_] = 8\ Exp[3\ x] + 4\ Sin[x];\)}], "Input",
  CellFrame->True,
  AspectRatioFixed->False,
  Background->RGBColor[1, 1, 0]],

Cell[TextData[
"Check the statement: (Be certain that you are solving the right problem!)"], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(L[x, y] == rhs[x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{\(-3\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], 
      "==", \(8\ \[ExponentialE]\^\(3\ x\) + 4\ Sin[x]\)}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"Define an annihilator from its characteristic polynomial"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell["\<\
A characteristic polynomial for an annihilator is easy to describe. \
Describe (in factored form) one for your problem in the boxed cell below. The \
notebook will then construct an annihilator from the expanded form of your \
polynomial.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[RHSPoly, Annihilator]\), "\n", 
    \(RHSPoly[r_] = Expand[r\ \((r\^2 + 1)\)\ \((r - 3)\)]\)}], "Input",
  CellFrame->True,
  AspectRatioFixed->False,
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(-3\)\ r + r\^2 - 3\ r\^3 + r\^4\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Construct the annihilator"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Annihilator[x_, u_] = MakeOperator[RHSPoly, r, x, u]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{
      RowBox[{\(-3\), " ", 
        RowBox[{
          SuperscriptBox["u", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{
        SuperscriptBox["u", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "x", "]"}], "-", 
      RowBox[{"3", " ", 
        RowBox[{
          SuperscriptBox["u", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{
        SuperscriptBox["u", 
          TagBox[\((4)\),
            Derivative],
          MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check the annihilator"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  StyleBox["The calculation below must return",
    FontColor->RGBColor[1, 0, 0]],
  " ",
  StyleBox["True",
    FontWeight->"Bold"],
  ", ",
  StyleBox["or else your annihilator is wrong",
    FontColor->RGBColor[1, 0, 0]],
  ". Do not proceed to further calculations until your annihilator is correct \
and this calculation returns ",
  StyleBox["True",
    FontWeight->"Bold"],
  ".\n\nIf the value returned is not ",
  StyleBox["True",
    FontWeight->"Bold"],
  ", go back and correct ",
  StyleBox["RHSPoly",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[",",
    FontFamily->"Courier"],
  "your proposed characteristic polynomial of the annihilator. Generate a new \
proposed ",
  StyleBox["Annihilator",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " until the result below is ",
  StyleBox["True",
    FontWeight->"Bold"],
  ". \n"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Annihilator[x, rhs] == 0 // Simplify\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[{
  "\nIf this result is ",
  StyleBox["True",
    FontWeight->"Bold"],
  " you can proceed. Otherwise correct ",
  StyleBox["RHSPoly",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Characteristic polynomial of the operator"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"We proceed, having a correct statement of the problem, and a correct \
annihilator. Here is the characteristic polynomial of the operator."], "Text",\

  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(CharPoly[r_] = Coefficient[L[x, Exp[r\ #1] &], Exp[r\ x]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-3\)\ r + r\^2\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"Characteristic polynomial of the composite operator"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Here is the characteristic polynomial of the composition of the operator and \
the annihilator. The theory says that we need it to construct the composition \
of the operator and the annihilator."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(BigPoly[r_] = Expand[CharPoly[r]\ RHSPoly[r]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(9\ r\^2 - 6\ r\^3 + 10\ r\^4 - 6\ r\^5 + r\^6\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The space in which yp will be found"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["A composite operator"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Construct the composition of the operator and the annihilator."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(CompositeOperator[x_, w_] = MakeOperator[BigPoly, r, x, w]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{
      RowBox[{"9", " ", 
        RowBox[{
          SuperscriptBox["w", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "-", 
      RowBox[{"6", " ", 
        RowBox[{
          SuperscriptBox["w", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{"10", " ", 
        RowBox[{
          SuperscriptBox["w", 
            TagBox[\((4)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}]}], "-", 
      RowBox[{"6", " ", 
        RowBox[{
          SuperscriptBox["w", 
            TagBox[\((5)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{
        SuperscriptBox["w", 
          TagBox[\((6)\),
            Derivative],
          MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["A Basis for the Kernel of the original operator"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Generate a basis for the kernel of the original operator using ",
  StyleBox["DKernel",
    FontWeight->"Bold"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Ker = DKernel[L[x, y] == 0, y[x], x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({1, \[ExponentialE]\^\(3\ x\)}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["A basis for the space in which yp will be found"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Generate a basis for the kernel of the composite operator."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(BigKernel = DKernel[CompositeOperator[x, w] == 0, w[x], x]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({1, x, \[ExponentialE]\^\(3\ x\), \[ExponentialE]\^\(3\ x\)\ x, Cos[x], 
      Sin[x]}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Our UC Set contains the members of BigKernel which are not in Ker. The \
built-in function ",
  StyleBox["Complement",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " does the job."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(UCSet = Complement[BigKernel, Ker]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({x, \[ExponentialE]\^\(3\ x\)\ x, Cos[x], Sin[x]}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The set ",
  StyleBox["UCSet",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a basis for the space in which our particular solution lies."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The assumed form for a particular solution"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Generate the required number of undetermined constants."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[a]\), "\n", 
    \(constants = Table[a[i], {i, Length[UCSet]}]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({a[1], a[2], a[3], a[4]}\)], "Output"]
}, Closed]],

Cell[TextData["This is the form our particular solution has:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Assume[x_] = UCSet . constants\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(x\ a[1] + \[ExponentialE]\^\(3\ x\)\ x\ a[2] + a[3]\ Cos[x] + 
      a[4]\ Sin[x]\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["A system of equations to solve"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["The expression we want to be 0."], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "The expression ",
  StyleBox["match",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is obtained by substituting our assumed solution into the operator and \
subtracting the espression rhs[x] that is the right hand side of our problem. \
This expression is zero when our assumed solution is an actual solution."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(match = Expand[L[x, Assume] - rhs[x]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-8\)\ \[ExponentialE]\^\(3\ x\) - 3\ a[1] + 
      3\ \[ExponentialE]\^\(3\ x\)\ a[2] - a[3]\ Cos[x] - 3\ a[4]\ Cos[x] - 
      4\ Sin[x] + 3\ a[3]\ Sin[x] - a[4]\ Sin[x]\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["BigKernel in decreasing complexity"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Here is a basis for all of the function annihilated by our annihilator. \
There may be more functions here than in the right hand side of our problem. \
These are the only kinds of functions that can appear in the expression ",
  StyleBox["match",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImageKernel = 
      decreasing[DKernel[Annihilator[x, u] == 0, u[x], x]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({\[ExponentialE]\^\(3\ x\), Sin[x], Cos[x], 1}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The system of equation to be solved"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Equate the coefficients of the terms in ",
  StyleBox["match",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to zero. The hard one is the coefficient of 1, which does not actually \
occur in ",
  StyleBox["match",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". For this reason, as coefficients are identified, the corresponding terms \
are removed from ",
  StyleBox["match",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " until only a constant remains. \n\nIf  1  occurs as a component of ",
  StyleBox["ImageKernel",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " the constant that remains is the coefficient of 1. \n\nIf  1  does not \
appear, then the residual constant is zero, and is ignored."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(system = EquateCoeff[match, ImageKernel];\)\)], "Input",
  AspectRatioFixed->False],

Cell[TextData[{
  "Display the equations to be solved. Each line consists of a member of ",
  StyleBox["ImageKernel",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " followed by the corresponding equation."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Print["\<Solve this system of equations:\>"]\), "\n", 
    \(Do[Print["\<(\>", 
        ImageKernel\[LeftDoubleBracket]i\[RightDoubleBracket], "\<) :\>", 
        system\[LeftDoubleBracket]i\[RightDoubleBracket]], {i, 1, 
        Length[ImageKernel]}]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \("Solve this system of equations:"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("("\[InvisibleSpace]\[ExponentialE]\^\(3\ x\)\
\[InvisibleSpace]") :"\[InvisibleSpace]\(\(-8\) + 3\ a[2] == 0\)\),
      SequenceForm[ "(", 
        Power[ E, 
          Times[ 3, x]], ") :", 
        Equal[ 
          Plus[ -8, 
            Times[ 3, 
              a[ 2]]], 0]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("("\[InvisibleSpace]Sin[
          x]\[InvisibleSpace]") :"\[InvisibleSpace]\(\(-4\) + 3\ a[3] - a[4] == 
          0\)\),
      SequenceForm[ "(", 
        Sin[ x], ") :", 
        Equal[ 
          Plus[ -4, 
            Times[ 3, 
              a[ 3]], 
            Times[ -1, 
              a[ 4]]], 0]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("("\[InvisibleSpace]Cos[
          x]\[InvisibleSpace]") :"\[InvisibleSpace]\(\(-a[3]\) - 3\ a[4] == 
          0\)\),
      SequenceForm[ "(", 
        Cos[ x], ") :", 
        Equal[ 
          Plus[ 
            Times[ -1, 
              a[ 3]], 
            Times[ -3, 
              a[ 4]]], 0]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("("\[InvisibleSpace]1\[InvisibleSpace]") :"\
\[InvisibleSpace]\(\(-3\)\ a[1] == 0\)\),
      SequenceForm[ "(", 1, ") :", 
        Equal[ 
          Times[ -3, 
            a[ 1]], 0]],
      Editable->False]], "Print"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["A particular solution & check"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData[
"Solve the system and substitute into the assumed form."], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Here is the particular solution we were seeking."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(yp[x_] = 
      Assume[x] /. \(Solve[system, 
            constants]\)\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",\

  AspectRatioFixed->False],

Cell[BoxData[
    \(8\/3\ \[ExponentialE]\^\(3\ x\)\ x + \(6\ Cos[x]\)\/5 - \(2\ \
Sin[x]\)\/5\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check to see that yp is a solution"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "This calculation should return ",
  StyleBox["True",
    FontWeight->"Bold"],
  ". This indicates that we have a valid particular solution."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[L[x, yp] == rhs[x]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["A Complete Solution"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Here is a complete solution of the given problem. It can be manipulated to \
give solutions for initial or boundary value problems by evaluating the \
constants {c[1], c[2], ...}. As given, the constants are arbitrary."], "Text",\

  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Clear[soln]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(soln[x_] = yp[x] + Ker . Table[c[i], {i, Length[Ker]}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(8\/3\ \[ExponentialE]\^\(3\ x\)\ x + 
      c[1] + \[ExponentialE]\^\(3\ x\)\ c[
          2] + \(6\ Cos[x]\)\/5 - \(2\ Sin[x]\)\/5\)], "Output"]
}, Closed]],

Cell["Check.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[L[x, soln] == rhs[x]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Implementation (initialization)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData[
"Load the package which finds the kernel of linear differential operators."], 
  "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Needs["\<RossDE`DKernel`\>"]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Needs::"nocont" \(\(:\)\(\ \)\) 
      "Context \!\(\"RossDE`DKernel`\"\) was not created when Needs was \
evaluated."\)], "Message"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"Recover the operator form its characteristic polynomial"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[{\(Clear[
        MakeOperator];\), "\n", \(MakeOperator::"\<polyForm\>" = "\<The first \
parameter, which was supplied as ``, should be the name of a polynomial \
function of ``.\>";\), "\n", \(Off[RuleDelayed::"\<rhs\>"];\), "\n", 
    RowBox[{
      RowBox[{\(MakeOperator[p_, r_, x_, y_]\), ":=", 
        RowBox[{"Block", "[", 
          RowBox[{\({q = Expand[p[r] - p[0]]}\), ",", 
            RowBox[{"If", "[", 
              RowBox[{\(TrueQ[Head[p] == Symbol]\), ",", 
                RowBox[{\(q + p[0]\ y[x]\), "/.", 
                  RowBox[{"{", 
                    RowBox[{
                      RowBox[{"r", "\[Rule]", 
                        RowBox[{
                          SuperscriptBox["y", "\[Prime]",
                            MultilineFunction->None], "[", "x", "]"}]}], ",", 
                      
                      RowBox[{\(r\^p_\), "\[Rule]", 
                        RowBox[{
                          SuperscriptBox["y", 
                            TagBox[\((p)\),
                              Derivative],
                            MultilineFunction->None], "[", "x", "]"}]}]}], 
                    "}"}]}], 
                ",", \(Message[MakeOperator::"\<polyForm\>", p, r]\)}], 
              "]"}]}], "]"}]}], ";"}], "\n", \(On[
      RuleDelayed::"\<rhs\>"]\)}], "Input",
  PageWidth->PaperWidth,
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Order a set by decreasing complexity"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(decreasing[solnList_] := 
      Block[{i, t}, 
        t = Table[{LeafCount[
                solnList\[LeftDoubleBracket]i\[RightDoubleBracket]], 
              solnList\[LeftDoubleBracket]i\[RightDoubleBracket]}, {i, 1, 
              Length[solnList]}]; t = Sort[t]; Last /@ Reverse[t]]\)], "Input",\

  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Equate Coefficients"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[{
    \(Clear[EquateCoeff]\), "\n", 
    \(EquateCoeff[match_, TestSet_] := 
      Block[{m, item, lis, result, this}, m = match; lis = TestSet; 
        result = {}; 
        While[TrueQ[Length[lis] > 0], item = First[lis]; 
          lis = Rest[lis]; \n\t\tIf[\[InvisibleSpace]TrueQ[item == 1], 
            AppendTo[result, m == 0]; Return[result]]; \n\t\t\tthis = 
            Coefficient[m, item]; 
          m = Expand[
              m - this*item]; \n\t\t\tIf[\(\(\[InvisibleSpace]\)\(! \((TrueQ[
                  item == 1])\)\)\), AppendTo[result, this == 0]]]; this = m; 
        If[\(\(\[InvisibleSpace]\)\(! \((TrueQ[this == 0])\)\)\), 
          AppendTo[result, this == 0]]; result]\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{591, 368},
WindowMargins->{{60, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Info3306946056-4776161"->{
    Cell[3593, 106, 246, 4, 55, "Print",
      CellTags->"Info3306946056-4776161"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Info3306946056-4776161", 26096, 937}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 104, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1883, 57, 38, 0, 26, "SmallText"],
Cell[1924, 59, 1193, 24, 266, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3142, 87, 95, 2, 56, "Section",
  Evaluatable->False],
Cell[3240, 91, 215, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3480, 102, 110, 2, 27, "Input"],
Cell[3593, 106, 246, 4, 55, "Print",
  CellTags->"Info3306946056-4776161"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3888, 116, 102, 2, 36, "Section",
  Evaluatable->False],
Cell[3993, 120, 196, 6, 32, "Text",
  Evaluatable->False],
Cell[4192, 128, 555, 14, 75, "Input"],
Cell[4750, 144, 152, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4927, 152, 77, 2, 27, "Input"],
Cell[5007, 156, 395, 10, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5451, 172, 135, 3, 36, "Section",
  Evaluatable->False],
Cell[5589, 177, 311, 7, 68, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5925, 188, 210, 5, 63, "Input"],
Cell[6138, 195, 67, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6242, 201, 106, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6373, 207, 112, 2, 27, "Input"],
Cell[6488, 211, 650, 19, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7187, 236, 102, 2, 46, "Subsection",
  Evaluatable->False],
Cell[7292, 240, 943, 33, 122, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8260, 277, 96, 2, 27, "Input"],
Cell[8359, 281, 38, 1, 27, "Output"]
}, Closed]],
Cell[8412, 285, 267, 11, 50, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8728, 302, 119, 2, 36, "Section",
  Evaluatable->False],
Cell[8850, 306, 215, 5, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9090, 315, 117, 2, 27, "Input"],
Cell[9210, 319, 50, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9309, 326, 130, 3, 36, "Section",
  Evaluatable->False],
Cell[9442, 331, 270, 5, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9737, 340, 105, 2, 27, "Input"],
Cell[9845, 344, 79, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9973, 351, 113, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10111, 357, 101, 2, 46, "Subsection",
  Evaluatable->False],
Cell[10215, 361, 137, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10377, 368, 118, 2, 27, "Input"],
Cell[10498, 372, 916, 28, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11463, 406, 128, 2, 46, "Subsection",
  Evaluatable->False],
Cell[11594, 410, 197, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11816, 421, 96, 2, 27, "Input"],
Cell[11915, 425, 64, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12028, 432, 128, 2, 46, "Subsection",
  Evaluatable->False],
Cell[12159, 436, 134, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12318, 443, 118, 2, 27, "Input"],
Cell[12439, 447, 120, 2, 29, "Output"]
}, Closed]],
Cell[12574, 452, 269, 9, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12868, 465, 94, 2, 27, "Input"],
Cell[12965, 469, 83, 1, 29, "Output"]
}, Closed]],
Cell[13063, 473, 230, 8, 32, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13342, 487, 120, 2, 36, "Section",
  Evaluatable->False],
Cell[13465, 491, 130, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13620, 498, 130, 3, 43, "Input"],
Cell[13753, 503, 58, 1, 27, "Output"]
}, Closed]],
Cell[13826, 507, 119, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13970, 513, 90, 2, 27, "Input"],
Cell[14063, 517, 115, 2, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14227, 525, 108, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14360, 531, 112, 2, 46, "Subsection",
  Evaluatable->False],
Cell[14475, 535, 399, 10, 68, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14899, 549, 97, 2, 27, "Input"],
Cell[14999, 553, 206, 3, 45, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15254, 562, 115, 2, 46, "Subsection",
  Evaluatable->False],
Cell[15372, 566, 385, 10, 68, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15782, 580, 132, 3, 43, "Input"],
Cell[15917, 585, 80, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[16046, 592, 116, 2, 46, "Subsection",
  Evaluatable->False],
Cell[16165, 596, 816, 23, 140, "Text",
  Evaluatable->False],
Cell[16984, 621, 105, 2, 27, "Input"],
Cell[17092, 625, 274, 8, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[17391, 637, 313, 6, 59, "Input"],
Cell[17707, 645, 66, 1, 23, "Print"],
Cell[17776, 648, 352, 10, 25, "Print"],
Cell[18131, 660, 380, 12, 23, "Print"],
Cell[18514, 674, 373, 12, 23, "Print"],
Cell[18890, 688, 257, 7, 23, "Print"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[19208, 702, 107, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[19340, 708, 136, 3, 46, "Subsection",
  Evaluatable->False],
Cell[19479, 713, 122, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[19626, 719, 174, 5, 27, "Input"],
Cell[19803, 726, 108, 2, 42, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[19960, 734, 115, 2, 46, "Subsection",
  Evaluatable->False],
Cell[20078, 738, 219, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[20322, 749, 88, 2, 27, "Input"],
Cell[20413, 753, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[20512, 761, 97, 2, 36, "Section",
  Evaluatable->False],
Cell[20612, 765, 295, 6, 50, "Text",
  Evaluatable->False],
Cell[20910, 773, 44, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[20979, 778, 114, 2, 27, "Input"],
Cell[21096, 782, 165, 3, 42, "Output"]
}, Closed]],
Cell[21276, 788, 22, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[21323, 792, 90, 2, 27, "Input"],
Cell[21416, 796, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[21503, 803, 109, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[21637, 809, 161, 4, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[21823, 817, 116, 3, 27, "Input",
  InitializationCell->True],
Cell[21942, 822, 153, 3, 35, "Message"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[22144, 831, 140, 3, 28, "Subsubsection",
  Evaluatable->False],
Cell[22287, 836, 1416, 30, 217, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[23740, 871, 120, 2, 28, "Subsubsection",
  Evaluatable->False],
Cell[23863, 875, 378, 9, 75, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[24278, 889, 103, 2, 28, "Subsubsection",
  Evaluatable->False],
Cell[24384, 893, 779, 15, 203, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

